set sql_safe_updates=0;
SET @dataproviderId1=(SELECT id FROM dydt_data_provider WHERE `providerName`='Student Father Info');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
    per_father.firstName AS father_first_name,
    per_father.lastName AS father_last_name,
    per_father.mobileCountryCode AS father_mobile_country_code,
    per_father.mobileNumber AS father_mobile_no,
    per_father.middleName AS father_middle_name,
    per_father.firstNameOtherLanguage AS father_first_name_otherLang,
    per_father.middleNameOtherLanguage AS father_middle_name_otherLang,
    per_father.lastNameOtherLanguage AS father_last_name_otherLang
FROM
    students st
        INNER JOIN
    persons per ON st.personId = per.id
        INNER JOIN
    person_relationships per_rel ON per.id = per_rel.personId
        AND per_rel.relationship = "FATHER"
        INNER JOIN
    persons per_father ON per_rel.relatedPersonId = per_father.id',
    `resultColumnsDef` = 'father_first_name,father_last_name,father_mobile_country_code,father_mobile_no,father_middle_name,father_first_name_otherLang,father_middle_name_otherLang,father_last_name_otherLang'
WHERE
    `dataSourceCode` = 'Student Fathers Info' AND dataProviderId = @dataproviderId1;
set sql_safe_updates=1;


#------------------TRANSLATIONS---------------------

SET @dydtdatalinitemId=(SELECT id FROM `dydt_data_line_item` where dataSourceCode='Student Fathers Info');
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('father_first_name', 'Father First Name',@dydtdatalinitemId),
    ('father_mobile_no', 'Father Mobile Number',@dydtdatalinitemId),
    ('father_last_name', 'Father Last Name',@dydtdatalinitemId),
    ('father_mobile_country_code', 'Father Mobile Country Code',@dydtdatalinitemId),
    ('father_middle_name', 'Father Middle Name',@dydtdatalinitemId),
    ('father_first_name_otherLang', 'Father First Name Other Language',@dydtdatalinitemId),
    ('father_middle_name_otherLang', 'Father Middle Name Other Language',@dydtdatalinitemId),
    ('father_last_name_otherLang', 'Father Last Name Other Language',@dydtdatalinitemId);